IF EXISTS ( SELECT * 
            FROM   sysobjects 
            WHERE  name='SF_RapiPago_TX') 
BEGIN
    DROP FUNCTION [dbo].[SF_RapiPago_TX] 
END
GO

CREATE FUNCTION [dbo].[SF_RapiPago_TX](@pId_Trans INT, @pImporte DECIMAL(12,2)) 
RETURNS CHAR(90)
AS
BEGIN

DECLARE @Retorno		CHAR(90)
DECLARE @TipoRegistro	CHAR(1)
DECLARE @NroReferencia	CHAR(19)
DECLARE @IdentificFac	CHAR(20)
DECLARE @CodigoMoneda	CHAR(1)
DECLARE @FechaPriVenc	CHAR(8)
DECLARE @ImportePriVenc	CHAR(11)
DECLARE @FechaSegVenc	CHAR(8)
DECLARE @ImporteSegVenc	CHAR(11)
DECLARE @Filler			CHAR(11)
DECLARE @Id_Cliente		INT
DECLARE @Doc_Nro		BIGINT
DECLARE @Fecha_PriVenc	DATETIME
DECLARE @Anio_PriVenc	CHAR(4)
DECLARE @Mes_PriVenc	CHAR(2)
DECLARE @Dia_PriVenc	CHAR(2)
DECLARE @Fecha_SegVenc	DATETIME
DECLARE @Anio_SegVenc	CHAR(4)
DECLARE @Mes_SegVenc	CHAR(2)
DECLARE @Dia_SegVenc	CHAR(2)
DECLARE @MesSeg			DATETIME
DECLARE @UltDiaMesSeg	DATETIME
DECLARE @Id_Cliente_Externo VARCHAR(14)
DECLARE @Id_Cliente_Externo_Int INT

/*=================================================================================*/

SET @TipoRegistro = '5'

/*Nro. de Referencia*/
SET @Id_Cliente		= ISNULL((SELECT Id_Cliente FROM Cbtes WHERE Id_Trans = @pId_Trans),0)
SET @Doc_Nro	= ISNULL((SELECT Doc_Nro FROM Clientes WHERE Id_Cliente = @Id_Cliente), 0)
SET @Id_Cliente_Externo	= ISNULL((SELECT ISNULL(Id_Cliente_Externo, '0') FROM Clientes WHERE Id_Cliente = @Id_Cliente AND ISNUMERIC(Id_Cliente_Externo) = 1), '')
SET @Id_Cliente_Externo_Int = CONVERT(INT, @Id_Cliente_Externo)

--SET @NroReferencia = (SELECT RIGHT('                   ' + CAST(@Doc_Nro AS VARCHAR),19)) Modificado por archivo enviado por Rapipago (sebastian.babandryseca@gire.com) 24/08/2018 14:14Hs via ticket 14323.
SET @NroReferencia = (SELECT RIGHT('0000000000000000000' + CAST(@Id_Cliente_Externo_Int AS VARCHAR),19))
/*FIN Nro. de Referencia*/

/*Identificador de Factura*/
--Modificado por archivo enviado por Rapipago (sebastian.babandryseca@gire.com) 24/08/2018 14:14Hs via ticket 14323.
SET @IdentificFac = (SELECT LEFT(RIGHT('0000000000' + CAST(@pId_Trans AS VARCHAR),10) + '                    ', 20))
/*FIN Identificador de Factura*/

/*Fecha Primer Vencimiento*/
SET @Fecha_PriVenc = (SELECT Fecha_Venc FROM Cbtes WHERE Id_Trans = @pId_Trans)

SET @Anio_PriVenc	= CAST(DATEPART(YY,@Fecha_PriVenc) AS CHAR(4))
SET @Mes_PriVenc	= RIGHT('00' + CAST(MONTH(@Fecha_PriVenc) AS VARCHAR),2)
SET @Dia_PriVenc	= '12'

SET @FechaPriVenc = @Anio_PriVenc + @Mes_PriVenc + @Dia_PriVenc
/*FIN Fecha Primer Vencimiento*/

/*Importe Primer Vencimiento*/
SET @ImportePriVenc	= (SELECT RIGHT('00000000000' +  CAST(CAST((@pImporte * 100) AS INT) AS VARCHAR), 11))
/*FIN Importe Primer Vencimiento*/

/*Fecha Segundo Vencimiento*/
/*Pedido en Ticket: 10.418 el 24/04/2017 a las 11:05 */
SET @MesSeg = DATEADD(mm, 1, GETDATE())
SET @UltDiaMesSeg = dbo.SF_EOMONTH(@MesSeg)
SET @Fecha_SegVenc = (@UltDiaMesSeg)

SET @Anio_SegVenc	= CAST(DATEPART(YY,@Fecha_SegVenc) AS CHAR(4))
SET @Mes_SegVenc	= RIGHT('00' + CAST(MONTH(@Fecha_SegVenc) AS VARCHAR),2)
SET @Dia_SegVenc	= RIGHT('00' + CAST(DAY(@Fecha_SegVenc) AS VARCHAR),2)

SET @FechaSegVenc = @Anio_SegVenc + @Mes_SegVenc + @Dia_SegVenc
/*FIN Fecha Segundo Vencimiento*/

/*Importe Segundo Vencimiento*/
SET @ImporteSegVenc	= (SELECT RIGHT('00000000000' +  CAST(CAST((@pImporte * 100) AS INT) AS VARCHAR), 11))
/*FIN Importe Segundo Vencimiento*/

SET @CodigoMoneda = '0' /*Pesos*/
SET @Filler = '00000000000'

/*=================================================================================*/

SET @retorno =	@TipoRegistro   + /*01 caracter. Tipo de Registro Registro. Fijo: 5*/
				@NroReferencia	+ /*19 caracteres. Identificacion del Cliente en la empresa.*/
				@IdentificFac	+ /*20 caracteres. Identifacacion de la factura*/
				@CodigoMoneda	+ /*01 caracter. 0 = Pesos; 1 = dolares*/					
				@FechaPriVenc	+ /*08 caracteres. Fecha del Primer Vencimiento. 12 del Mes. AAAAMMDD*/
				@ImportePriVenc + /*11 caracteres. Importe del Primer Vencimiento. 9 enteros, 2 decimales*/
				@FechaSegVenc	+ /*08 caracteres. Fecha del Segundo Vencimiento. 27 del Mes. AAAAMMDD*/
				@ImporteSegVenc	+ /*11 caracteres. Importe del Segundo Vencimiento. 9 enteros, 2 decimales*/
				@Filler			  /*11 caracteres. Filler. Todos Ceros*/  

RETURN @retorno
END